/*
 * Decompiled with CFR 0.152.
 */
package net.quumi.mwforestry.tile;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.core.tiles.TilePowered;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.quumi.mwforestry.etc.MWHConfiguration;

public abstract class ForestryTileMultiEnergy
extends TilePowered
implements IEnergySink {
    private boolean addedToEnet = false;

    protected ForestryTileMultiEnergy(String hintKey, int capacityRf) {
        super(hintKey, Integer.MAX_VALUE, capacityRf);
    }

    public double getDemandedEnergy() {
        int storedRf = this.getEnergyStored(ForgeDirection.UP);
        int maxRf = this.getMaxEnergyStored(ForgeDirection.UP);
        int canAddRf = maxRf - storedRf;
        return Math.floor((double)canAddRf / (double)MWHConfiguration.RF_PER_EU);
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(ForgeDirection forgeDirection, double amount, double voltage) {
        int received = this.getEnergyManager().receiveEnergy(forgeDirection, (int)(amount * (double)MWHConfiguration.RF_PER_EU), false);
        double receivedEu = (double)received / (double)MWHConfiguration.RF_PER_EU;
        return amount - receivedEu;
    }

    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return true;
    }

    private void addToEnet() {
        if (!this.addedToEnet && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    private void removeFromEnet() {
        if (this.addedToEnet && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.addedToEnet) {
            this.addToEnet();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.removeFromEnet();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removeFromEnet();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.addToEnet();
    }
}

